﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;
using System.Xml.Xsl;
using System.Net.Mail;
using Gemini.Core.WebApplication.Base;
using PI.ZB.N1200.ELearning.BL.APIMobile.Model.Data;
using PI.ZB.N1200.ELearning.BL.APIMobile.Model;

namespace PI.ZB.N1200.ELearning.WebApplication.API
{
    public partial class ELearning : Gemini.Core.WebApplication.Base.APIComponent
    {
        internal class MethodStatsCompetencesView : BaseAPIMethod
        {
            private long _competence_id = 0;
            private int _studentId = 0;

            public MethodStatsCompetencesView(ELearning Component)
                : base(Component)
            {
            }

            public override string Name
            {
                get { return "statscompetencesview"; }
            }

            protected override bool DoValidate()
            {
                return true;
            }

            protected override void DoReadRequestParams()
            {
                string _student_Id = Component.APIRequestParams["student_id"];
                if (!string.IsNullOrEmpty(_student_Id))
                {
                    int.TryParse(_student_Id, out _studentId);
                }
                long.TryParse(Component.APIRequestParams["competence_id"], out _competence_id);
            }

            protected override GResponseData DoGetGResponseData()
            {
                if (User != null)
                {
                    FM.N001.Account.BL.BO.View.User _statsUser = User;
                    BL.Dictionary.GroupType _group = (BL.Dictionary.GroupType)User.GroupEnumID;
                    if ((_group == PI.ZB.N1200.ELearning.BL.Dictionary.GroupType.Instructor) && (_studentId > 0))
                    {
                        _statsUser = Component.BLELearning.RBL.Account.User.View.Restore(_studentId);
                    }

                    GStatsCompetenceView _GStatsCompetenceView = Component.BLELearning.APIMobile.GetStatsCompetenceView(_statsUser, _competence_id);
                    if (_GStatsCompetenceView != null)
                    {
                        StatusCode = StatusCodeType.OK;
                        return new GResponseData_StatsCompetenceView() { Data = _GStatsCompetenceView };
                    }
                    else
                    {
                        AddErrorMessage("Nie znaleziono rankingu dla ucznia.");
                        StatusCode = StatusCodeType.NotFound;
                    }
                }
                return null;
            }
        }
    }
}